################################################################################
#
# resiprocate
#
################################################################################

RESIPROCATE_VERSION = 1.13.2
RESIPROCATE_SITE = $(call github,resiprocate,resiprocate,resiprocate-$(RESIPROCATE_VERSION))
RESIPROCATE_LICENSE = VSL-1.0, BSD-3-Clause
RESIPROCATE_LICENSE_FILES = LICENSE.md
RESIPROCATE_CPE_ID_VENDOR = resiprocate
RESIPROCATE_INSTALL_STAGING = YES

RESIPROCATE_CONF_OPTS = -DWITH_C_ARES=ON
RESIPROCATE_DEPENDENCIES = c-ares

RESIPROCATE_CONF_OPTS += \
	-DBUILD_QPID_PROTON=OFF \
	-DBUILD_RECON=OFF \
	-DBUILD_REFLOW=OFF \
	-DBUILD_REPRO=OFF \
	-DBUILD_RETURN=OFF \
	-DBUILD_TFM=OFF \
	-DHAVE_CLOCK_GETTIME_MONOTONIC_EXITCODE=0

ifeq ($(BR2_PACKAGE_GEOIP),y)
RESIPROCATE_CONF_OPTS += -DUSE_MAXMIND_GEOIP=ON
RESIPROCATE_DEPENDENCIES += geoip
else
RESIPROCATE_CONF_OPTS += -DUSE_MAXMIND_GEOIP=OFF
endif

ifeq ($(BR2_PACKAGE_OPENSSL),y)
RESIPROCATE_CONF_OPTS += -DWITH_SSL=ON
RESIPROCATE_DEPENDENCIES += openssl host-pkgconf
else
RESIPROCATE_CONF_OPTS += -DWITH_SSL=OFF
endif

ifeq ($(BR2_PACKAGE_POPT),y)
RESIPROCATE_CONF_OPTS += -DUSE_POPT=ON
RESIPROCATE_DEPENDENCIES += popt
else
RESIPROCATE_CONF_OPTS += -DUSE_POPT=OFF
endif

ifeq ($(BR2_PACKAGE_RESIPROCATE_DTLS_SUPPORT),y)
RESIPROCATE_CONF_OPTS += -DUSE_DTLS=ON
else
RESIPROCATE_CONF_OPTS += -DUSE_DTLS=OFF
endif

ifeq ($(BR2_PACKAGE_RESIPROCATE_REND),y)
RESIPROCATE_CONF_OPTS += -DBUILD_REND=ON
RESIPROCATE_DEPENDENCIES += boost
else
RESIPROCATE_CONF_OPTS += -DBUILD_REND=OFF
endif

$(eval $(cmake-package))
