################################################################################
#
# libpng
#
################################################################################

LIBPNG_VERSION = 1.6.55
LIBPNG_SERIES = 16
LIBPNG_SOURCE = libpng-$(LIBPNG_VERSION).tar.xz
LIBPNG_SITE = https://downloads.sourceforge.net/project/libpng/libpng$(LIBPNG_SERIES)/$(LIBPNG_VERSION)
LIBPNG_LICENSE = Libpng-2.0
LIBPNG_LICENSE_FILES = LICENSE
LIBPNG_CPE_ID_VENDOR = libpng
# 0001-riscv-Support-only-RVV-1.0.patch
LIBPNG_AUTORECONF = YES
LIBPNG_INSTALL_STAGING = YES
LIBPNG_DEPENDENCIES = host-pkgconf zlib
HOST_LIBPNG_DEPENDENCIES = host-pkgconf host-zlib
LIBPNG_CONFIG_SCRIPTS = libpng$(LIBPNG_SERIES)-config libpng-config
LIBPNG_CONF_OPTS = --disable-tools
LIBPNG_CFLAGS = $(TARGET_CFLAGS)

ifeq ($(BR2_aarch64),y)
LIBPNG_CONF_OPTS += --enable-arm-neon
else ifeq ($(BR2_ARM_CPU_HAS_NEON):$(BR2_ARM_SOFT_FLOAT),y:)
LIBPNG_CFLAGS += -mfpu=neon
LIBPNG_CONF_OPTS += --enable-arm-neon
else
LIBPNG_CONF_OPTS += --disable-arm-neon
endif

ifeq ($(BR2_X86_CPU_HAS_SSE2),y)
LIBPNG_CONF_OPTS += --enable-intel-sse
else
LIBPNG_CONF_OPTS += --disable-intel-sse
endif

LIBPNG_CONF_ENV = \
	CFLAGS="$(LIBPNG_CFLAGS)"

$(eval $(autotools-package))
$(eval $(host-autotools-package))
